elexname			= CElexElex ;
elexfilename		= ".\Elex\ElexElex";

include = {*
#include <string.h>
*};

define = {*
char* _processBlock(const char* _re)
{
	int iLen = strlen(_re);
	char* ret = new char[iLen - 4 + 1];
	strncpy(ret, _re + 2, iLen - 4);
	ret[iLen - 4] = 0;

	return ret;
}
*};

EQUAL						{:=:};
COLON						{:;:};
VALUE						{:#(value#):};
IGNORE						{:#(ignore#):};
ELEXNAME					{:elexname:};
ELEXFILENAME				{:elexfilename:};
INCLUDE						{:include:};
DEFINE						{:define:};
ID							{:[a-zA-Z][a-zA-z0-9$#_]+:};

FILE						{:#"[#|#*#?#"<>/#:" "\n\t]~([#\/]|[#|#*#?#"<>/#:\n\t]~)*[#|#*#?#"<>/#:" "\n\t]~#":}
{*
	int iPathLen = strlen(GetText()) - 2;
	char* pPathName = new char[iPathLen + 1];
	strncpy(pPathName, GetText() + 1, iPathLen);
	pPathName[iPathLen] = 0;

	SetText(pPathName);
	delete[] pPathName;
*};

RE_BLOCK					{:#{#:([###":]~|(#:#}~)|(###:)|(###:~)|(#"([#"#\]~|(#\#")|(#\#"~))*#"))*#:#}:}
{*
	char* pBlock = _processBlock(GetText());
	SetText(pBlock);
	delete[] pBlock;

	const char* pText = GetText();
	int len = strlen(pText), i;
	for (i = 0; i < len; i++) {
		if (pText[i] == '\n') NEWLINE;
	}
*};

SCRIPT_BLOCK				{:#{#*((#*#}~)|#*~)*#*#}:}
{*
	char* pBlock = _processBlock(GetText());
	SetText(pBlock);
	delete[] pBlock;

	const char* pText = GetText();
	int len = strlen(pText), i;
	for (i = 0; i < len; i++) {
		if (pText[i] == '\n') NEWLINE;
	}
*};

REMARK			(ignore)	{:/#*((/#*~)|([/#*]~)|(#*/~))*#*/:}
{*
	const char* pText = GetText();
	int len = strlen(pText), i;
	for (i = 0; i < len; i++) {
		if (pText[i] == '\n') NEWLINE;
	}
*};

REMARKLINE		(ignore)	{://[\r\n]~*\r?\n:}
{*
	NEWLINE;
*};

WHITESPACE		(ignore)	{:[" "\t]+:};

NEWLINE			(ignore)	{:\r?\n:}
{*
	NEWLINE;
*};

